<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class FirebaseAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // First check if user is authenticated
        if (!session('firebase_user')) {
            Log::warning('Unauthenticated admin access attempt to: ' . $request->url());
            
            if ($request->expectsJson()) {
                return response()->json(['error' => 'Unauthorized'], 401);
            }
            
            return redirect()->route('login')->with('error', 'Please log in to continue.');
        }

        // Check if user has admin privileges
        $firebaseUser = session('firebase_user');
        if (!isset($firebaseUser['is_admin']) || !$firebaseUser['is_admin']) {
            Log::warning('Non-admin user attempted to access admin area: ' . $firebaseUser['email']);
            
            if ($request->expectsJson()) {
                return response()->json(['error' => 'Forbidden - Admin access required'], 403);
            }
            
            return redirect()->route('login')->with('error', 'Admin access required.');
        }

        // Optional: Check for specific admin roles if you implement them later
        // $adminRole = $firebaseUser['admin_role'] ?? null;
        // if (!in_array($adminRole, ['admin', 'super_admin'])) {
        //     return redirect()->route('login')->with('error', 'Insufficient admin privileges.');
        // }

        return $next($request);
    }
}